#include "stdafx.h"
#include "win_demo.h"
#include "DialogNetParam.h"
#include "afxdialogex.h"
#include "common_struct.h"
#include "perser_json.h"
#include "pack_json.h"
#include "win_demoDlg.h"
#include "common_tool.h"
#include "sdks.h"


extern int m_handle;
extern int m_chn_option;
IMPLEMENT_DYNAMIC(CDialogNetParam, CDialogEx)

CDialogNetParam::CDialogNetParam(CWnd* pParent /*=NULL*/)
	: CDialogEx(IDD_DIALOG_NET_PARAM, pParent)
{

}

CDialogNetParam::~CDialogNetParam()
{
}

jy_dev_net_param_list_t stNetParamList;
BOOL CDialogNetParam::OnInitNetParam()
{
	int m_mtu = 0;
	char *p_result = NULL;
	CString strins;
	jy_dev_net_id_t stNetID = { 0 };
	int nRet = sdks_dev_get_net_param(m_handle, m_chn_option, &p_result);
	if (!nRet)
	{
		json_perser_net_param(p_result, &stNetParamList);
		if (stNetParamList.size > 0)
		{
			stNetID.id_list[0] = stNetParamList.net_param[0].m_nNetId;
			for (int i = 0; i < stNetParamList.size; ++i)
			{
				stNetID.id_list[i] = stNetParamList.net_param[i].m_nNetId;
				strins.Format(_T("%d"), stNetID.id_list[i]);
				m_net_param_id.InsertString(i, strins);
			}
			stNetID.size = stNetParamList.size;
			m_net_param_id.SetCurSel(0);
		}
	}
	sdks_dev_get_mtu(m_handle, &m_mtu);
	strins.Format(_T("%d"), m_mtu);
	m_net_param_mtu.SetWindowTextA(strins);

	m_net_param_ip_proto.AddString(TEXT("IPv4"));
	m_net_param_ip_proto.SetCurSel(0);
	OnCBnDropdownNetId();
	OnBnClickedCheckNetDhcp();
	return TRUE;
}

void CDialogNetParam::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COMBO_NET_ID, m_net_param_id);
	DDX_Control(pDX, IDC_COMBO_NET_IP_PROTO, m_net_param_ip_proto);
	DDX_Control(pDX, IDC_EDIT_NET_IP, m_net_param_ip);
	DDX_Control(pDX, IDC_EDIT_NET_MASK, m_net_param_mask);
	DDX_Control(pDX, IDC_EDIT_NET_GW, m_net_param_gw);
	DDX_Control(pDX, IDC_EDIT_NET_DNS1, m_net_param_dns1);
	DDX_Control(pDX, IDC_EDIT_NET_DNS2, m_net_param_dns2);
	DDX_Control(pDX, IDC_EDIT_NET_MTU, m_net_param_mtu);
}


BEGIN_MESSAGE_MAP(CDialogNetParam, CDialogEx)
	ON_CBN_SELCHANGE(IDC_COMBO_NET_ID, &CDialogNetParam::OnCBnDropdownNetId)
	ON_BN_CLICKED(IDC_CHECK_NET_DHCP, &CDialogNetParam::OnBnClickedCheckNetDhcp)
	ON_BN_CLICKED(IDOK, &CDialogNetParam::OnBnClickedOk)
END_MESSAGE_MAP()


void CDialogNetParam::OnCBnDropdownNetId()
{
	CString str_id;
	int id_index = m_net_param_id.GetCurSel();
	m_net_param_id.GetLBText(id_index, str_id);
	int net_id = _ttoi(str_id);
	for (int i = 0; i < stNetParamList.size; ++i)
	{
		if (net_id == stNetParamList.net_param[i].m_nNetId)
		{
			((CButton*)GetDlgItem(IDC_CHECK_NET_DHCP))->SetCheck(0);
			if (stNetParamList.net_param[i].m_bDHCP)
			{
				((CButton*)GetDlgItem(IDC_CHECK_NET_DHCP))->SetCheck(1);
			}
			m_net_param_ip.SetWindowTextA(stNetParamList.net_param[i].m_strLocalIp);
			m_net_param_mask.SetWindowTextA(stNetParamList.net_param[i].m_strLocalSubnetMask);
			m_net_param_gw.SetWindowTextA(stNetParamList.net_param[i].m_strGateway);
			m_net_param_dns1.SetWindowTextA(stNetParamList.net_param[i].m_strPrimaryDNSIp);
			m_net_param_dns2.SetWindowTextA(stNetParamList.net_param[i].m_strSpareDNSIp);
		}
	}
}

void CDialogNetParam::OnBnClickedCheckNetDhcp()
{
	if (((CButton*)GetDlgItem(IDC_CHECK_NET_DHCP))->GetCheck() == TRUE)
	{
		m_net_param_ip.EnableWindow(FALSE);
		m_net_param_mask.EnableWindow(FALSE);
		m_net_param_gw.EnableWindow(FALSE);
	}
	else 
	{
		m_net_param_ip.EnableWindow(TRUE);
		m_net_param_mask.EnableWindow(TRUE);
		m_net_param_gw.EnableWindow(TRUE);
	}
}

static int check_ipv4_addr(char *ip)
{
	if (ip == NULL || ip[0] == '0' || ip[0] == '\0') {
		return -1;
	}

	for (int i = 0, count = 0; i < strlen(ip); i++) {
		if ((ip[i] != '.') && (ip[i] < '0' || ip[i] > '9')) {
			return -1;
		}
		if (ip[i] == '.') {
			count++;
			if (count > 3) {
				return -1;
			}
		}
	}

	int ip_num[4] = {-1, -1, -1, -1};
	char ip_s[4][4];
	memset(ip_s, 0, sizeof(char[4]) * 4);

	sscanf(ip, "%[^.].%[^.].%[^.].%[^ ]", ip_s[0], ip_s[1], ip_s[2], ip_s[3]);
	sscanf(ip_s[0], "%d", &ip_num[0]);
	sscanf(ip_s[1], "%d", &ip_num[1]);
	sscanf(ip_s[2], "%d", &ip_num[2]);
	sscanf(ip_s[3], "%d", &ip_num[3]);

	for (int i = 0; i < 4; i++) {
		if (strlen(ip_s[i]) == 0 || (ip_s[i][0] == '0' && ip_s[i][1] != '\0') || ip_num[i] < 0 || ip_num[i] > 255) {
			return -1;
		}
	}

	return 0;
}

void CDialogNetParam::OnBnClickedOk()
{
	CDialogEx::OnOK();
	char* p_param = NULL;
	CString str_id;
	CString str_tmp;
	char original_ip[16] = { "\0" };
	int id_index = m_net_param_id.GetCurSel();
	m_net_param_id.GetLBText(id_index, str_id);
	int net_id = _ttoi(str_id);
	m_net_param_mtu.GetWindowText(str_tmp);
	int n_mtu = _ttoi(str_tmp);
	sdks_dev_set_mtu(m_handle, n_mtu);
	for (int i = 0; i < stNetParamList.size; ++i)
	{
		if (net_id == stNetParamList.net_param[i].m_nNetId)
		{
			bool bDHCPflag = stNetParamList.net_param[i].m_bDHCP;
			strcpy(original_ip, stNetParamList.net_param[i].m_strLocalIp);
			if (((CButton*)GetDlgItem(IDC_CHECK_NET_DHCP))->GetCheck() == FALSE)
			{
				stNetParamList.net_param[i].m_bDHCP = false;
				m_net_param_ip.GetWindowText(str_tmp);
				strcpy(stNetParamList.net_param[i].m_strLocalIp, str_tmp);
				m_net_param_mask.GetWindowText(str_tmp);
				strcpy(stNetParamList.net_param[i].m_strLocalSubnetMask, str_tmp);
				m_net_param_gw.GetWindowText(str_tmp);
				strcpy(stNetParamList.net_param[i].m_strGateway, str_tmp);
			}
			else {
				stNetParamList.net_param[i].m_bDHCP = true;
			}
			m_net_param_dns1.GetWindowText(str_tmp);
			strcpy(stNetParamList.net_param[i].m_strPrimaryDNSIp, str_tmp);
			m_net_param_dns2.GetWindowText(str_tmp);
			strcpy(stNetParamList.net_param[i].m_strSpareDNSIp, str_tmp);
			if (check_ipv4_addr(stNetParamList.net_param[i].m_strLocalIp))
			{
				MessageBoxA("Failed to set the device IP address!");
				return;
			}
			if (check_ipv4_addr(stNetParamList.net_param[i].m_strLocalSubnetMask))
			{
				MessageBoxA("Failed to set the device Mask address!");
				return;
			}
			if (NULL == stNetParamList.net_param[i].m_strGateway)
			{
				if (check_ipv4_addr(stNetParamList.net_param[i].m_strGateway))
				{
					MessageBoxA("Failed to set the device gateway!");
					return;
				}
			}
			if (NULL == stNetParamList.net_param[i].m_strPrimaryDNSIp)
			{
				if (check_ipv4_addr(stNetParamList.net_param[i].m_strPrimaryDNSIp))
				{
					MessageBoxA("Failed to set the device primary DNS!");
					return;
				}
			}
			if (NULL == stNetParamList.net_param[i].m_strSpareDNSIp)
			{
				if (check_ipv4_addr(stNetParamList.net_param[i].m_strSpareDNSIp))
				{
					MessageBoxA("Failed to set the device spare DNS!");
					return;
				}
			}

			UINT j = 0;
			j = MessageBoxA(_T("Are you sure you want to set up the network?"), _T("Prompt"), MB_YESNO | MB_ICONQUESTION);	
			if (IDYES == j)
			{
				pack_json_net_param(&stNetParamList, &p_param);
				int nRet = sdks_dev_set_net_param(m_handle, p_param);
				if ((!nRet) && ((bDHCPflag != stNetParamList.net_param[i].m_bDHCP) || (strcmp(original_ip, stNetParamList.net_param[i].m_strLocalIp))))
				{
					MessageBoxA("The device will be restart,then client needs to be reconnected!");
					dev_reboot();
				}
			}
		}
	}
}
